#include <vector>
#include <iostream>
#include <algorithm>

enum BloodGroup {
    O = 0,
    A,
    B,
    AB
};
const std::string symbol[4] = { "O", "A", "B", "AB" };
std::istream& operator >>(std::istream&, BloodGroup&);
std::ostream& operator <<(std::ostream&, const BloodGroup&);

struct Blood {
    BloodGroup group;
    int amount;
};

class Tank {
private:  // Fields
    int storage[4];
public:   // Constructors
    Tank();
    Tank(std::istream&);
    Tank(const int&, const int&, const int&, const int&);
    Tank(const Tank&) = delete;
public:   // Methods
    int Stored(const BloodGroup&) const;
    Blood Take(const BloodGroup&, const int&);
public:   // Operators
    Tank& operator =(const Tank&) = delete;
};

class Patient {
private:  // Fields
    int log[4];
    int need;
    int number;
    BloodGroup group;
    static int total;
private:  // Constructors
    Patient();
public:   // Constructors
    Patient(std::istream&);
    Patient(const BloodGroup&, const int&);
    Patient(const Patient&);
public:   // Methods
    int GetNeed() const;
    int GetNumber() const;
    bool Transfer(Tank&, const BloodGroup&);
    void PrintLog() const;
    BloodGroup GetGropup() const;
    std::string Recieved() const;
    static int GetTotal();
    static Patient Default();
public:   // Operators
    Patient& operator =(const Patient&);
};

void Untie();
bool PerformTransfer(std::vector<Patient>&, Tank&);

int main() {
    Untie();
    int n;
    std::cin >> n;
    std::vector<Patient> patients(n, Patient::Default());
    Tank tank(std::cin);
    for (auto& patient : patients) {
        patient = Patient(std::cin);
    }
    if (PerformTransfer(patients, tank)) {
        std::cout << "moguce" << std::endl;
        std::string sum;
        for (int i = 0; i < n; i++) {
            sum += patients[i].Recieved();
        }
        std::cout << sum << std::endl;
    }
    else {
        std::cout << "nemoguce" << std::endl;
    }
    return 0;
}

void Untie() {
    std::ios_base::sync_with_stdio(false);
    std::cout.tie(nullptr);
    std::cerr.tie(nullptr);
    std::cin.tie(nullptr);
}
bool PerformTransfer(std::vector<Patient>& patients, Tank& tank) {
    std::sort(patients.begin(), patients.end(), [](const Patient& p1, const Patient& p2) { return p1.GetGropup() < p2.GetGropup(); });
    auto current = patients.begin();
    while (current->GetGropup() == O) {
        if (!current->Transfer(tank, O)) {
            return false;
        }
        current++;
    }
    auto aBegin = current;
    for (int i = 1; i < 4; i++) {
        while (current->GetGropup() == i) {
            current->Transfer(tank, (BloodGroup) i);
            current++;
        }
    }
    current = aBegin;
    while (current->GetGropup() != AB) {
        if (!current->Transfer(tank, O)) {
            return false;
        }
        current++;
    }
    BloodGroup group = O;
    while (current != patients.end()) {
        current->Transfer(tank, group);
        group = (BloodGroup) ((int) group - !tank.Stored(group));
        current->Transfer(tank, group);
        if (group == AB) {
            return false;
        }
        current++;
    }
    std::sort(patients.begin(), patients.end(), [](const Patient& p1, const Patient& p2) { return p1.GetNumber() < p2.GetNumber(); });
    return true;
}
std::ostream& operator <<(std::ostream& out, const BloodGroup& group) {
    out << symbol[group];
    return out;
}
std::istream& operator >>(std::istream& in, BloodGroup& group) {
    std::string symbol;
    in >> symbol;
    for (int i = 0; i < 4; i++) {
        if (::symbol[i] == symbol) {
            group = (BloodGroup) i;
        }
    }
    return in;
}


// Tank
Tank::Tank()
: storage{} {
}
Tank::Tank(std::istream& in) {
    for (int& group : storage) {
        in >> group;
    }
}
Tank::Tank(const int& o, const int& a, const int& b, const int& ab)
: storage{ o, a, b, ab } {
}

Blood Tank::Take(const BloodGroup& group, const int& amount) {
    int taken = std::min(storage[group], amount);
    storage[group] -= taken;
    return { group, taken };
}
int Tank::Stored(const BloodGroup& group) const {
    return storage[group];
}


// Patient
int Patient::total = 0;

Patient::Patient()
: need(-1), log{-1, -1, -1, -1} {
}
Patient::Patient(std::istream& in)
: number(total++), log{} {
    in >> group >> need;
}
Patient::Patient(const BloodGroup& group, const int& need)
: group(group), need(need), number(total++), log{} {
}
Patient::Patient(const Patient& original)
: group(original.group), need(original.need), number(original.number) {
    for (int i = 0; i < 4; i++) {
        log[i] = original.log[i];
    }
}

int Patient::GetNeed() const {
    return need;
}
int Patient::GetNumber() const {
    return number;
}
int Patient::GetTotal() {
    return total;
}
bool Patient::Transfer(Tank& tank, const BloodGroup& group) {
    Blood blood = tank.Take(group, need);
    need -= blood.amount;
    log[blood.group] += blood.amount;
    return !need;
}
void Patient::PrintLog() const {
    std::cout << log[0] << ' ' << log[1] << ' ' << log[2] << ' ' << log[3] << '\n';
}
BloodGroup Patient::GetGropup() const {
    return group;
}
std::string Patient::Recieved() const {
    return std::to_string(log[0]) + ' ' + std::to_string(log[1]) + ' ' + std::to_string(log[2]) + ' ' + std::to_string(log[3]) + '\n';
}
Patient Patient::Default() {
    return Patient();
}

Patient& Patient::operator =(const Patient& value) {
    group = value.group; 
    need = value.need;
    number = value.number;
    for (int i = 0; i < 4; i++) {
        log[i] = value.log[i];
    }
    return *this;
}